using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmLogInSupplies
	/// </summary>
	public class FrmLogInSupplies : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region variables

		/// <summary>
		/// This is a flag so that we eliminate flicker
		/// </summary>
		private bool _isNameSet = false;

		/// <summary>
		/// For comments.  If 'other' is selected, we want to change Details to Details*
		/// </summary>
		private bool _detailsRequired = false;
		private System.Collections.ArrayList _pendingSupplies;
		private System.Collections.Hashtable _lvSuppliesChecked;
		private BOL.Supply _currentSupply;
		private bool _isLoading = false;

		//Did the user select a supply from the list to re-edit it?
		private bool _isEdit = false;
		private System.Collections.ArrayList _supplyTypes;
		private System.Collections.ArrayList _supplyTypeIds;

		#endregion

		#region Form Controls

		private System.Windows.Forms.GroupBox grpInvoice;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.TextBox txtInvoiceNumber;
		private System.Windows.Forms.Label lblInvoiceNumber;
		private System.Windows.Forms.DateTimePicker dtpReceivedDate;
		private System.Windows.Forms.Label lblReceivedDate;
		private System.Windows.Forms.DateTimePicker dtpExpirationDate;
		private System.Windows.Forms.Panel pnlComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.Label lblComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.RadioButton rdoSatisfactory;
		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.GroupBox grpInventory;
		private System.Windows.Forms.ListView lvInventory;
		private System.Windows.Forms.ColumnHeader colCheckBox;
		private System.Windows.Forms.ColumnHeader colLotNumber;
		private System.Windows.Forms.ColumnHeader colExpirationDate;
		private System.Windows.Forms.ColumnHeader colInvoice;
		private System.Windows.Forms.ColumnHeader colManufacturer;
		private System.Windows.Forms.ColumnHeader colInspection;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpSupply;
		private System.Windows.Forms.GroupBox grpVisualInspection;
		private System.Windows.Forms.TextBox txtDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturerSupplyName;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSupplyType;
		private System.Windows.Forms.Label lblSupplyType;
		private System.Windows.Forms.Label lblManufacturerSupplyName;
		private System.Windows.Forms.ColumnHeader colSupplyName;
		private System.Windows.Forms.ColumnHeader colQty;
		private System.Windows.Forms.ColumnHeader colSupplyType;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updQuantity;
		private System.Windows.Forms.Label lblQuantity;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Contructors/Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmLogInSupplies()
		{
			this._isLoading = true;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.ResetInputFields(false);

			this._pendingSupplies = new System.Collections.ArrayList();
			this._lvSuppliesChecked = new System.Collections.Hashtable();

			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmLogInSupplies));
			this.grpInvoice = new System.Windows.Forms.GroupBox();
			this.cmbManufacturer = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.txtInvoiceNumber = new System.Windows.Forms.TextBox();
			this.lblInvoiceNumber = new System.Windows.Forms.Label();
			this.dtpReceivedDate = new System.Windows.Forms.DateTimePicker();
			this.lblReceivedDate = new System.Windows.Forms.Label();
			this.grpSupply = new System.Windows.Forms.GroupBox();
			this.updQuantity = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.dtpExpirationDate = new System.Windows.Forms.DateTimePicker();
			this.grpVisualInspection = new System.Windows.Forms.GroupBox();
			this.pnlComment = new System.Windows.Forms.Panel();
			this.lblDetails = new System.Windows.Forms.Label();
			this.lblComment = new System.Windows.Forms.Label();
			this.txtDetails = new System.Windows.Forms.TextBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.rdoSatisfactory = new System.Windows.Forms.RadioButton();
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.btnClear = new System.Windows.Forms.Button();
			this.cmbManufacturerSupplyName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblQuantity = new System.Windows.Forms.Label();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.cmbSupplyType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblSupplyType = new System.Windows.Forms.Label();
			this.lblManufacturerSupplyName = new System.Windows.Forms.Label();
			this.grpImage1 = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.grpInventory = new System.Windows.Forms.GroupBox();
			this.lvInventory = new System.Windows.Forms.ListView();
			this.colCheckBox = new System.Windows.Forms.ColumnHeader();
			this.colSupplyName = new System.Windows.Forms.ColumnHeader();
			this.colLotNumber = new System.Windows.Forms.ColumnHeader();
			this.colExpirationDate = new System.Windows.Forms.ColumnHeader();
			this.colQty = new System.Windows.Forms.ColumnHeader();
			this.colInvoice = new System.Windows.Forms.ColumnHeader();
			this.colManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colSupplyType = new System.Windows.Forms.ColumnHeader();
			this.colInspection = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpInvoice.SuspendLayout();
			this.grpSupply.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updQuantity)).BeginInit();
			this.grpVisualInspection.SuspendLayout();
			this.pnlComment.SuspendLayout();
			this.grpImage1.SuspendLayout();
			this.grpInventory.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Log In Supplies";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpInvoice
			// 
			this.grpInvoice.AccessibleDescription = "invoice";
			this.grpInvoice.AccessibleName = "invoice";
			this.grpInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInvoice.Controls.Add(this.cmbManufacturer);
			this.grpInvoice.Controls.Add(this.lblManufacturer);
			this.grpInvoice.Controls.Add(this.txtInvoiceNumber);
			this.grpInvoice.Controls.Add(this.lblInvoiceNumber);
			this.grpInvoice.Controls.Add(this.dtpReceivedDate);
			this.grpInvoice.Controls.Add(this.lblReceivedDate);
			this.grpInvoice.Location = new System.Drawing.Point(56, 32);
			this.grpInvoice.Name = "grpInvoice";
			this.grpInvoice.Size = new System.Drawing.Size(630, 92);
			this.grpInvoice.TabIndex = 0;
			this.grpInvoice.TabStop = false;
			this.grpInvoice.Text = "Invoice";
			// 
			// cmbManufacturer
			// 
			this.cmbManufacturer.AccessibleDescription = "manufacturer";
			this.cmbManufacturer.AccessibleName = "manufacturer";
			this.cmbManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbManufacturer.Interval = 500;
			this.cmbManufacturer.Location = new System.Drawing.Point(152, 64);
			this.cmbManufacturer.MaxLength = 50;
			this.cmbManufacturer.Name = "cmbManufacturer";
			this.cmbManufacturer.Size = new System.Drawing.Size(464, 22);
			this.cmbManufacturer.TabIndex = 5;
			this.cmbManufacturer.Leave += new System.EventHandler(this.cmbManufacturer_Leave);
			this.cmbManufacturer.TextChanged += new System.EventHandler(this.cmbManufacturer_TextChanged);
			this.cmbManufacturer.SelectedIndexChanged += new System.EventHandler(this.cmbManufacturer_SelectedIndexChanged);
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(8, 64);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(144, 20);
			this.lblManufacturer.TabIndex = 4;
			this.lblManufacturer.Text = "Manufacturer*";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtInvoiceNumber
			// 
			this.txtInvoiceNumber.AccessibleDescription = "Invoice Number";
			this.txtInvoiceNumber.AccessibleName = "Invoice Number";
			this.txtInvoiceNumber.Location = new System.Drawing.Point(152, 40);
			this.txtInvoiceNumber.MaxLength = 20;
			this.txtInvoiceNumber.Name = "txtInvoiceNumber";
			this.txtInvoiceNumber.Size = new System.Drawing.Size(184, 20);
			this.txtInvoiceNumber.TabIndex = 3;
			this.txtInvoiceNumber.Text = "";
			this.txtInvoiceNumber.TextChanged += new System.EventHandler(this.txtInvoiceNumber_TextChanged);
			// 
			// lblInvoiceNumber
			// 
			this.lblInvoiceNumber.Location = new System.Drawing.Point(8, 40);
			this.lblInvoiceNumber.Name = "lblInvoiceNumber";
			this.lblInvoiceNumber.Size = new System.Drawing.Size(144, 20);
			this.lblInvoiceNumber.TabIndex = 2;
			this.lblInvoiceNumber.Text = "Invoice Number*";
			this.lblInvoiceNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpReceivedDate
			// 
			this.dtpReceivedDate.AccessibleDescription = "Received Date";
			this.dtpReceivedDate.AccessibleName = "Received Date";
			this.dtpReceivedDate.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpReceivedDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedDate.Location = new System.Drawing.Point(152, 16);
			this.dtpReceivedDate.Name = "dtpReceivedDate";
			this.dtpReceivedDate.Size = new System.Drawing.Size(184, 20);
			this.dtpReceivedDate.TabIndex = 1;
			this.dtpReceivedDate.CloseUp += new System.EventHandler(this.ValidateReceivedDate);
			this.dtpReceivedDate.ValueChanged += new System.EventHandler(this.ValidateReceivedDate);
			// 
			// lblReceivedDate
			// 
			this.lblReceivedDate.Location = new System.Drawing.Point(8, 16);
			this.lblReceivedDate.Name = "lblReceivedDate";
			this.lblReceivedDate.Size = new System.Drawing.Size(144, 20);
			this.lblReceivedDate.TabIndex = 0;
			this.lblReceivedDate.Text = "Received Date*";
			this.lblReceivedDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSupply
			// 
			this.grpSupply.AccessibleDescription = "supply";
			this.grpSupply.AccessibleName = "supply";
			this.grpSupply.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSupply.Controls.Add(this.updQuantity);
			this.grpSupply.Controls.Add(this.dtpExpirationDate);
			this.grpSupply.Controls.Add(this.grpVisualInspection);
			this.grpSupply.Controls.Add(this.btnClear);
			this.grpSupply.Controls.Add(this.cmbManufacturerSupplyName);
			this.grpSupply.Controls.Add(this.btnAdd);
			this.grpSupply.Controls.Add(this.lblQuantity);
			this.grpSupply.Controls.Add(this.lblExpirationDate);
			this.grpSupply.Controls.Add(this.txtLotNumber);
			this.grpSupply.Controls.Add(this.lblLotNumber);
			this.grpSupply.Controls.Add(this.cmbSupplyType);
			this.grpSupply.Controls.Add(this.lblSupplyType);
			this.grpSupply.Controls.Add(this.lblManufacturerSupplyName);
			this.grpSupply.Enabled = false;
			this.grpSupply.Location = new System.Drawing.Point(56, 128);
			this.grpSupply.Name = "grpSupply";
			this.grpSupply.Size = new System.Drawing.Size(630, 176);
			this.grpSupply.TabIndex = 1;
			this.grpSupply.TabStop = false;
			this.grpSupply.Text = "Supply";
			// 
			// updQuantity
			// 
			this.updQuantity.AccessibleDescription = "quantity received";
			this.updQuantity.AccessibleName = "quantity received";
			this.updQuantity.Location = new System.Drawing.Point(152, 112);
			this.updQuantity.Maximum = new System.Decimal(new int[] {
																		999,
																		0,
																		0,
																		0});
			this.updQuantity.Minimum = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.updQuantity.Name = "updQuantity";
			this.updQuantity.Size = new System.Drawing.Size(64, 20);
			this.updQuantity.TabIndex = 9;
			this.updQuantity.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updQuantity.Value = new System.Decimal(new int[] {
																	  1,
																	  0,
																	  0,
																	  0});
			this.updQuantity.TextChanged += new System.EventHandler(this.updQuantity_ValueChanged);
			this.updQuantity.Leave += new System.EventHandler(this.updQuantity_Leave);
			this.updQuantity.ValueChanged += new System.EventHandler(this.updQuantity_ValueChanged);
			// 
			// dtpExpirationDate
			// 
			this.dtpExpirationDate.AccessibleDescription = "lot expiration date";
			this.dtpExpirationDate.AccessibleName = "lot expiration date";
			this.dtpExpirationDate.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpirationDate.Location = new System.Drawing.Point(152, 88);
			this.dtpExpirationDate.Name = "dtpExpirationDate";
			this.dtpExpirationDate.Size = new System.Drawing.Size(184, 20);
			this.dtpExpirationDate.TabIndex = 7;
			this.dtpExpirationDate.Value = new System.DateTime(2004, 7, 6, 23, 59, 0, 0);
			this.dtpExpirationDate.ValueChanged += new System.EventHandler(this.dtpExpirationDate_ValueChanged);
			// 
			// grpVisualInspection
			// 
			this.grpVisualInspection.AccessibleDescription = "visual inspection";
			this.grpVisualInspection.AccessibleName = "visual inspection";
			this.grpVisualInspection.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpVisualInspection.Controls.Add(this.pnlComment);
			this.grpVisualInspection.Controls.Add(this.rdoSatisfactory);
			this.grpVisualInspection.Controls.Add(this.rdoUnsatisfactory);
			this.grpVisualInspection.Location = new System.Drawing.Point(344, 8);
			this.grpVisualInspection.Name = "grpVisualInspection";
			this.grpVisualInspection.Size = new System.Drawing.Size(280, 132);
			this.grpVisualInspection.TabIndex = 10;
			this.grpVisualInspection.TabStop = false;
			this.grpVisualInspection.Text = "Visual Inspection*";
			// 
			// pnlComment
			// 
			this.pnlComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlComment.Controls.Add(this.lblDetails);
			this.pnlComment.Controls.Add(this.lblComment);
			this.pnlComment.Controls.Add(this.txtDetails);
			this.pnlComment.Controls.Add(this.cmbComment);
			this.pnlComment.Location = new System.Drawing.Point(8, 56);
			this.pnlComment.Name = "pnlComment";
			this.pnlComment.Size = new System.Drawing.Size(262, 68);
			this.pnlComment.TabIndex = 2;
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(0, 28);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 2;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(0, 4);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(60, 20);
			this.lblComment.TabIndex = 0;
			this.lblComment.Text = "Comment";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDetails
			// 
			this.txtDetails.AccessibleDescription = "details";
			this.txtDetails.AccessibleName = "details";
			this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDetails.Enabled = false;
			this.txtDetails.Location = new System.Drawing.Point(60, 28);
			this.txtDetails.MaxLength = 255;
			this.txtDetails.Multiline = true;
			this.txtDetails.Name = "txtDetails";
			this.txtDetails.Size = new System.Drawing.Size(198, 40);
			this.txtDetails.TabIndex = 3;
			this.txtDetails.Text = "";
			this.txtDetails.Leave += new System.EventHandler(this.txtDetails_Leave);
			this.txtDetails.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtDetails_KeyUp);
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "comment";
			this.cmbComment.AccessibleName = "comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Enabled = false;
			this.cmbComment.Interval = 500;
			this.cmbComment.Location = new System.Drawing.Point(60, 4);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(198, 22);
			this.cmbComment.TabIndex = 1;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// rdoSatisfactory
			// 
			this.rdoSatisfactory.AccessibleDescription = "satisfactory";
			this.rdoSatisfactory.AccessibleName = "satisfactory";
			this.rdoSatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoSatisfactory.Location = new System.Drawing.Point(8, 16);
			this.rdoSatisfactory.Name = "rdoSatisfactory";
			this.rdoSatisfactory.Size = new System.Drawing.Size(260, 20);
			this.rdoSatisfactory.TabIndex = 0;
			this.rdoSatisfactory.TabStop = true;
			this.rdoSatisfactory.Text = "&Satisfactory";
			this.rdoSatisfactory.CheckedChanged += new System.EventHandler(this.SatisfactoryIndicatorChanged);
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "unsatisfactory";
			this.rdoUnsatisfactory.AccessibleName = "unsatisfactory";
			this.rdoUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(8, 36);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.Size = new System.Drawing.Size(260, 20);
			this.rdoUnsatisfactory.TabIndex = 1;
			this.rdoUnsatisfactory.TabStop = true;
			this.rdoUnsatisfactory.Text = "&Unsatisfactory";
			this.rdoUnsatisfactory.CheckedChanged += new System.EventHandler(this.SatisfactoryIndicatorChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(546, 144);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 12;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// cmbManufacturerSupplyName
			// 
			this.cmbManufacturerSupplyName.AccessibleDescription = "Manufacturer Supply Name";
			this.cmbManufacturerSupplyName.AccessibleName = "Manufacturer Supply Name";
			this.cmbManufacturerSupplyName.Interval = 500;
			this.cmbManufacturerSupplyName.Location = new System.Drawing.Point(152, 12);
			this.cmbManufacturerSupplyName.MaxLength = 75;
			this.cmbManufacturerSupplyName.Name = "cmbManufacturerSupplyName";
			this.cmbManufacturerSupplyName.Size = new System.Drawing.Size(184, 22);
			this.cmbManufacturerSupplyName.TabIndex = 1;
			this.cmbManufacturerSupplyName.TextChanged += new System.EventHandler(this.ManufacturerSupplyNameEvent);
			this.cmbManufacturerSupplyName.SelectedIndexChanged += new System.EventHandler(this.ManufacturerSupplyNameEvent);
			// 
			// btnAdd
			// 
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.Location = new System.Drawing.Point(466, 144);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.Size = new System.Drawing.Size(75, 23);
			this.btnAdd.TabIndex = 11;
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			// 
			// lblQuantity
			// 
			this.lblQuantity.Location = new System.Drawing.Point(8, 112);
			this.lblQuantity.Name = "lblQuantity";
			this.lblQuantity.Size = new System.Drawing.Size(168, 20);
			this.lblQuantity.TabIndex = 8;
			this.lblQuantity.Text = "Quantity Received*";
			this.lblQuantity.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 88);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(144, 20);
			this.lblExpirationDate.TabIndex = 6;
			this.lblExpirationDate.Text = "Lot Expiraton Date*";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "lot number";
			this.txtLotNumber.AccessibleName = "lot number";
			this.txtLotNumber.Location = new System.Drawing.Point(152, 64);
			this.txtLotNumber.MaxLength = 15;
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.Size = new System.Drawing.Size(184, 20);
			this.txtLotNumber.TabIndex = 5;
			this.txtLotNumber.Text = "";
			this.txtLotNumber.TextChanged += new System.EventHandler(this.LotNumberEvent);
			this.txtLotNumber.Leave += new System.EventHandler(this.LotNumberEvent);
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 64);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(144, 20);
			this.lblLotNumber.TabIndex = 4;
			this.lblLotNumber.Text = "Lot Number*";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbSupplyType
			// 
			this.cmbSupplyType.AccessibleDescription = "supply type";
			this.cmbSupplyType.AccessibleName = "supply type";
			this.cmbSupplyType.Interval = 500;
			this.cmbSupplyType.Location = new System.Drawing.Point(152, 38);
			this.cmbSupplyType.Name = "cmbSupplyType";
			this.cmbSupplyType.Size = new System.Drawing.Size(184, 22);
			this.cmbSupplyType.TabIndex = 3;
			this.cmbSupplyType.Leave += new System.EventHandler(this.SupplyTypeEvent);
			this.cmbSupplyType.SelectedIndexChanged += new System.EventHandler(this.SupplyTypeEvent);
			// 
			// lblSupplyType
			// 
			this.lblSupplyType.Location = new System.Drawing.Point(8, 40);
			this.lblSupplyType.Name = "lblSupplyType";
			this.lblSupplyType.Size = new System.Drawing.Size(144, 20);
			this.lblSupplyType.TabIndex = 2;
			this.lblSupplyType.Text = "Supply Type*";
			this.lblSupplyType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblManufacturerSupplyName
			// 
			this.lblManufacturerSupplyName.Location = new System.Drawing.Point(8, 16);
			this.lblManufacturerSupplyName.Name = "lblManufacturerSupplyName";
			this.lblManufacturerSupplyName.Size = new System.Drawing.Size(152, 20);
			this.lblManufacturerSupplyName.TabIndex = 0;
			this.lblManufacturerSupplyName.Text = "Manufacturer Supply Name*";
			this.lblManufacturerSupplyName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpImage1
			// 
			this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage1.Controls.Add(this.pictureBox2);
			this.grpImage1.Location = new System.Drawing.Point(4, 32);
			this.grpImage1.Name = "grpImage1";
			this.grpImage1.Size = new System.Drawing.Size(48, 408);
			this.grpImage1.TabIndex = 6;
			this.grpImage1.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 12);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(40, 44);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox2.TabIndex = 1;
			this.pictureBox2.TabStop = false;
			// 
			// grpInventory
			// 
			this.grpInventory.AccessibleDescription = "inventory";
			this.grpInventory.AccessibleName = "inventory";
			this.grpInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInventory.Controls.Add(this.lvInventory);
			this.grpInventory.Location = new System.Drawing.Point(56, 308);
			this.grpInventory.Name = "grpInventory";
			this.grpInventory.Size = new System.Drawing.Size(630, 132);
			this.grpInventory.TabIndex = 2;
			this.grpInventory.TabStop = false;
			this.grpInventory.Text = "Inventory";
			// 
			// lvInventory
			// 
			this.lvInventory.AccessibleDescription = "inventory";
			this.lvInventory.AccessibleName = "inventory";
			this.lvInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvInventory.CheckBoxes = true;
			this.lvInventory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colCheckBox,
																						  this.colSupplyName,
																						  this.colLotNumber,
																						  this.colExpirationDate,
																						  this.colQty,
																						  this.colInvoice,
																						  this.colManufacturer,
																						  this.colSupplyType,
																						  this.colInspection});
			this.lvInventory.FullRowSelect = true;
			this.lvInventory.Location = new System.Drawing.Point(8, 16);
			this.lvInventory.MultiSelect = false;
			this.lvInventory.Name = "lvInventory";
			this.lvInventory.Size = new System.Drawing.Size(614, 108);
			this.lvInventory.TabIndex = 0;
			this.lvInventory.View = System.Windows.Forms.View.Details;
			this.lvInventory.SelectedIndexChanged += new System.EventHandler(this.lvInventory_SelectedIndexChanged);
			this.lvInventory.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvInventory_ItemCheck);
			// 
			// colCheckBox
			// 
			this.colCheckBox.Text = "";
			this.colCheckBox.Width = 25;
			// 
			// colSupplyName
			// 
			this.colSupplyName.Text = "Supply Name";
			this.colSupplyName.Width = 90;
			// 
			// colLotNumber
			// 
			this.colLotNumber.Text = "Lot Number";
			this.colLotNumber.Width = 80;
			// 
			// colExpirationDate
			// 
			this.colExpirationDate.Text = "Expires";
			this.colExpirationDate.Width = 100;
			// 
			// colQty
			// 
			this.colQty.Text = "Qty";
			this.colQty.Width = 30;
			// 
			// colInvoice
			// 
			this.colInvoice.Text = "Invoice No.";
			this.colInvoice.Width = 65;
			// 
			// colManufacturer
			// 
			this.colManufacturer.Text = "Manufacturer";
			this.colManufacturer.Width = 100;
			// 
			// colSupplyType
			// 
			this.colSupplyType.Text = "Supply Type";
			this.colSupplyType.Width = 80;
			// 
			// colInspection
			// 
			this.colInspection.Text = "Inspection";
			this.colInspection.Width = 80;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(610, 444);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(530, 444);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// FrmLogInSupplies
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 473);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpInventory);
			this.Controls.Add(this.grpImage1);
			this.Controls.Add(this.grpSupply);
			this.Controls.Add(this.grpInvoice);
			this.hlphelpChm.SetHelpKeyword(this, "Log_In_Supplies.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(700, 500);
			this.Name = "FrmLogInSupplies";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Log In Supplies";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmLogInSupplies_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpInvoice, 0);
			this.Controls.SetChildIndex(this.grpSupply, 0);
			this.Controls.SetChildIndex(this.grpImage1, 0);
			this.Controls.SetChildIndex(this.grpInventory, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpInvoice.ResumeLayout(false);
			this.grpSupply.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updQuantity)).EndInit();
			this.grpVisualInspection.ResumeLayout(false);
			this.pnlComment.ResumeLayout(false);
			this.grpImage1.ResumeLayout(false);
			this.grpInventory.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion



		#region Methods

		/// <summary>
		/// Sets up the Form Controls/Properties for initial display
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC081.FrmLogInSupplies());
			//
			System.DateTime currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			this.dtpReceivedDate.Value = currentDateTime;
			this.dtpReceivedDate.MaxDate = currentDateTime;

			//Default Time = 12AM
			this.dtpExpirationDate.Value = currentDateTime.Date.AddHours(23).AddMinutes(59);
			this.dtpExpirationDate.MinDate = currentDateTime;

			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Text = "&Add";
			this.btnAdd.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToAddOrUpdate().ResString);

			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC081.AddOneSupply().ResString);

			this.ttToolTip.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearEntries().ResString);
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);

			//Populate the ComboBoxes
			this.cmbManufacturer.LookupEnabled = false;
			this.PopulateManufacturerComboBox();
			//this.PopulateSupplyNameComboBox();
			this.cmbManufacturerSupplyName.LookupEnabled = false;
			this.PopulateSupplyTypeComboBox();
			this.PopulateCommentComboBox();
			
			//Set the date pickers
			this.dtpExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpReceivedDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
		}

		/// <summary>
		/// Fills the cmbManufacturer Items with unique existing database values
		/// </summary>
		private void PopulateManufacturerComboBox()
		{
			System.Collections.ArrayList alNames = BOL.Supply.GetManufacturerNameList();

			for(int ndx=0; ndx < alNames.Count; ndx++)
			{
				this.cmbManufacturer.Items.Add(alNames[ndx].ToString());
			}
		}

		/// <summary>
		/// Fills the cmbManufacturerSupplyName Items with unique existing database values
		/// </summary>
		private void PopulateSupplyNameComboBox()
		{
			this.cmbManufacturerSupplyName.Items.Clear();
			//
			System.Collections.ArrayList alNames = BOL.Supply.GetSupplyNameList(this._currentSupply.ManufacturerName);
			//
			for(int ndx=0; ndx < alNames.Count; ndx++)
			{
				this.cmbManufacturerSupplyName.Items.Add(alNames[ndx].ToString());
			}
		}

		/// <summary>
		/// Fills the cmbManufacturerSupplyName Items with unique existing database values
		/// </summary>
		private void PopulateSupplyTypeComboBox()
		{
			System.Collections.ArrayList[] supplyData = BOL.Supply.GetSupplyTypeList();

			this._supplyTypeIds = supplyData[0];
			this._supplyTypes = supplyData[1];

			for (int ndx=0; ndx < this._supplyTypes.Count; ndx++)
			{
				this.cmbSupplyType.Items.Add(this._supplyTypes[ndx].ToString());
			}
		}


		/// <summary>
		/// Fills the cmbComment Items with unique existing database values for "Reagent and Supply" Category
		/// </summary>
		private void PopulateCommentComboBox()
		{
			System.Data.DataTable dtComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode, "RS");

			foreach(System.Data.DataRow dr in dtComments.Rows)
			{
				this.cmbComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}


		/// <summary>
		/// Clears the form and resets all controls to their initial state, creates new object
		/// </summary>
		/// <param name="setInvoiceValues">Used when adding one supply after another -- automatically
		/// sets the values for Invoice Number, Date Received and Manufacturer</param>
		private void ResetInputFields(bool setInvoiceValues)
		{
			bool origValue = this._isLoading;
			this._isLoading = true;

			this._isNameSet = false;

			//Supply group
			this.cmbManufacturerSupplyName.SelectedIndex = -1;
			this.cmbManufacturerSupplyName.Text = string.Empty;
			this.cmbSupplyType.SelectedIndex = -1;
			this.txtLotNumber.Text = string.Empty;
			this.dtpExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date.AddHours(23).AddMinutes(59);
			this.updQuantity.Value = 1;
			this.errError.SetVbecsError(updQuantity, string.Empty); // **** 508 Compliance ***
			this.rdoSatisfactory.Checked = false;
			this.rdoUnsatisfactory.Checked = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoSatisfactory.TabStop = true;

			this.cmbComment.SelectedIndex = -1;
			this.txtDetails.Text = string.Empty;

			//Supply group is disabled until Invoice stuff is valid
			if (setInvoiceValues)
			{
				this.EnableSupplyFields(false);
			}
			else
			{
				this.grpSupply.Enabled = false;
			}

			//Most likely we will always want this to happen
			this.GetNewSupply();

			//Set button state
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Text = "&Add";

			//Set the invoice values if requested (when Add is clicked)
			if (setInvoiceValues)
			{
				this._currentSupply.InvoiceNumber = this.txtInvoiceNumber.Text;
				this._currentSupply.ReceiptDate = this.dtpReceivedDate.Value;
				this._currentSupply.ManufacturerName = this.cmbManufacturer.Text;
			}

			this._isLoading = origValue;
		}

		
		/// <summary>
		/// Creates a new _currentSupply object and attaches all the events
		/// </summary>
		private void GetNewSupply()
		{
			//REMOVE the events just to be safe
			if (this._currentSupply != null)
			{
				this._currentSupply.Invalid -= new EventHandler(this.ObjectValidityChange);
				this._currentSupply.IsDirtyChanged -= new EventHandler(this.ObjectValidityChange);
				this._currentSupply.Valid -= new EventHandler(this.ObjectValidityChange);
			}

			//Reset the object
			this._currentSupply = null;
			if (this._isEdit && this.lvInventory.SelectedItems.Count > 0)
				this._currentSupply = (BOL.Supply)this.lvInventory.SelectedItems[0].Tag;
			else
				this._currentSupply = new BOL.Supply(System.Guid.NewGuid());

			//Reattach the events
			this._currentSupply.Invalid += new EventHandler(this.ObjectValidityChange);
			this._currentSupply.IsDirtyChanged += new EventHandler(this.ObjectValidityChange);
			this._currentSupply.Valid += new EventHandler(this.ObjectValidityChange);

			this._currentSupply.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmLogInSupplies.RuleSets.NewSupply, this._isEdit);
			
			if (!this._isEdit)
			{
				//Set the 2 date's, since they're automatically populated on the screen
				this._currentSupply.ReceiptDate = this.dtpReceivedDate.Value;
				this._currentSupply.LotExpirationDate = this.dtpExpirationDate.Value;
				//Set the Quantity, since it's defaulted on the screen
				this._currentSupply.LotQuantity = (int)this.updQuantity.Value;
				this._currentSupply.AvailableQuantity = this._currentSupply.LotQuantity;
			}

			//Fire the event to reset the buttons/tooltips
			this.ObjectValidityChange(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Loads the Inventory listview with all the logged supplies
		/// </summary>
		private void RefreshInventory()
		{
			this.lvInventory.Items.Clear();

			for(int ndx=0; ndx < this._pendingSupplies.Count; ndx++)
			{
				BOL.Supply addItem = (BOL.Supply)this._pendingSupplies[ndx];
				
				string inspectionText = (addItem.SatisfactoryIndicator == true) ? "Satisfactory" : "Unsatisfactory";

				System.Windows.Forms.ListViewItem lvi = new System.Windows.Forms.ListViewItem();

				lvi.Checked = (bool)this._lvSuppliesChecked[addItem.SupplyGuid];

				lvi.Text = string.Empty;	//I guess this is because of the checkbox?
				lvi.SubItems.Add(addItem.SupplyName);
				lvi.SubItems.Add(addItem.LotNumber);
				lvi.SubItems.Add(addItem.LotExpirationDate.ToString(Common.VBECSDateTime.DateTimeFormat));
				lvi.SubItems.Add(addItem.LotQuantity.ToString());
				lvi.SubItems.Add(addItem.InvoiceNumber);
				lvi.SubItems.Add(addItem.ManufacturerName);
				lvi.SubItems.Add(addItem.SupplyTypeText);
				lvi.SubItems.Add(inspectionText);
				lvi.Tag = addItem;

				this.lvInventory.Items.Add(lvi);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvInventory);

		}


		/// <summary>
		/// Checks DB to see if enetered supply previously existed
		/// </summary>
		/// <returns></returns>
		private bool CheckForExistingSupply()
		{
			bool supplyExists = false;

			if (this.cmbSupplyType.Text.Length > 0 && this.txtLotNumber.Text.Length > 0 && this.txtInvoiceNumber.Text.Length > 0)
			{
				System.Guid supplyGuid = this._currentSupply.GetSupplyByInvoiceLotNumber();

				//If the Guid that comes back isn't empty, then it exists and we prompt to edit
				if (supplyGuid != System.Guid.Empty)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC081.EditExistingSupply()) == DialogResult.Yes)
					{
						GUI.FrmRecordSupplyUsage frmUpdate = new FrmRecordSupplyUsage(supplyGuid);

						//An Abort DialogResult means the Locking failed, so dispose the form (err msg shows in SetLocks())
						if (frmUpdate.DialogResult != DialogResult.Abort)
						{
							frmUpdate.ShowDialog(this);
						}
						else
						{
							frmUpdate.Dispose();
						}
					}
					supplyExists = true;
				}
			}
			return(supplyExists);
		}

		/// <summary>
		/// This is needed to keep a flow.  They can't add a supply without a name first
		/// </summary>
		/// <param name="enabledAllFields"></param>
		private void EnableSupplyFields(bool enabledAllFields)
		{
			this.cmbManufacturerSupplyName.Enabled = true;

			this.cmbSupplyType.Enabled = enabledAllFields;
			this.txtLotNumber.Enabled = enabledAllFields;
			this.dtpExpirationDate.Enabled = enabledAllFields;
			this.updQuantity.Enabled = enabledAllFields;

			this.grpVisualInspection.Enabled = enabledAllFields;
		}


		/// <summary>
		/// Sets the OK button caption to ADD or EDIT depending on values
		/// </summary>
		private void UpdateAddButtonCaption()
		{
			if (this._isEdit) return;		//If we're editing a listitem, leave it alone

			string strCaption = "&Add";

			if (this._currentSupply.SupplyName != string.Empty &&
				this._currentSupply.SupplyTypeId != 0 &&
				this._currentSupply.LotNumber != string.Empty)
			{
				//Cycle through the listview, to see if they've already entered it
				for (int ndx=0; ndx < this.lvInventory.Items.Count; ndx++)
				{
					BOL.Supply tmpSupply = (BOL.Supply)this.lvInventory.Items[ndx].Tag;

					//If the supply is already in the list, then replace it
					if (tmpSupply.SupplyName == this._currentSupply.SupplyName &&
						tmpSupply.SupplyTypeId == this._currentSupply.SupplyTypeId &&
						tmpSupply.LotNumber == this._currentSupply.LotNumber)
					{
						strCaption = "&Update";
						break;
					}
				}
			}

			this.btnAdd.Text = strCaption;
		}

		#endregion

		#region ControlEvents

		/// <summary>
		/// Adds current supply to the array, and rebuilds the supplylist
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			if (!this._isEdit)	//Are we adding a new one
			{
				//Cycle through the listview, to see if they've already entered it
				for (int ndx=0; ndx < this.lvInventory.Items.Count; ndx++)
				{
					BOL.Supply tmpSupply = (BOL.Supply)this.lvInventory.Items[ndx].Tag;

					//If the supply is already in the list, then replace it
					if (tmpSupply.SupplyName == this._currentSupply.SupplyName &&
						tmpSupply.SupplyTypeId == this._currentSupply.SupplyTypeId &&
						tmpSupply.LotNumber == this._currentSupply.LotNumber)
					{
						//Clean up our tmp storage
						this._lvSuppliesChecked.Add(this._currentSupply.SupplyGuid, true);
						this._lvSuppliesChecked.Remove(tmpSupply.SupplyGuid);

						this._pendingSupplies[ndx] = this._currentSupply;
						this.UpdateManufacturerComboBoxes();
						this.RefreshInventory();
						this.ResetInputFields(true);
						return;
					}
				}

				//Since we don't have it in the list, see if it's already in the DB
				//If checkForEisitnSupply fails, then it didn't exist, and continue
				if (!this.CheckForExistingSupply())
				{
					this._pendingSupplies.Add(this._currentSupply);
					this._lvSuppliesChecked.Add(this._currentSupply.SupplyGuid, true);
				}
				else
				{
					//Unit was found and either edited or ignored, clear fields
					this.ResetInputFields(true);
					return;
				}
			}
			else
			{
				this._isEdit = false;
				for (int ndx=0; ndx < this._pendingSupplies.Count; ndx ++ )
				{
					BOL.Supply tmpSupply = (BOL.Supply)this._pendingSupplies[ndx];

					if (tmpSupply.SupplyGuid == this._currentSupply.SupplyGuid)
					{
						this._pendingSupplies[ndx] = this._currentSupply;
						this._lvSuppliesChecked[this._currentSupply.SupplyGuid] = true;
						break;
					}
				}
			}

			this.UpdateManufacturerComboBoxes();
			this.RefreshInventory();
			this.ResetInputFields(true);
		}


		/// <summary>
		/// Updates the combobox values with the user entered junk
		/// </summary>
		private void UpdateManufacturerComboBoxes()
		{
			//First do the Manufacturer combobox ----------------------------------------
			bool foundValue = false;

			foreach(string typeText in this.cmbManufacturer.Items)
			{
				if (typeText == this.cmbManufacturer.Text)
				{
					foundValue = true;
					break;
				}
			}
			
			if (!foundValue)
			{
				this.cmbManufacturer.Items.Add(this.cmbManufacturer.Text);
			}

			//Now do the Manufacturer Supply Name combobox ------------------------------
			foundValue = false;
			foreach(string typeText in this.cmbManufacturerSupplyName.Items)
			{
				if (typeText == this.cmbManufacturerSupplyName.Text)
				{
					foundValue = true;
					break;
				}
			}
			
			if (!foundValue)
			{
				this.cmbManufacturerSupplyName.Items.Add(this.cmbManufacturerSupplyName.Text);
			}

		}

		/// <summary>
		/// Clears all the input fields
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this._isEdit = false;		//need to set this here to avoid setting OK button incorrectly
			this.ResetInputFields(true);
		}


		private void txtInvoiceNumber_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.InvoiceNumber = this.txtInvoiceNumber.Text;
			}
		}

		private void ValidateReceivedDate(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				System.DateTime currentTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

				dtpReceivedDate.MaxDate = currentTime;

				if (dtpReceivedDate.Value > currentTime)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DateSetToFuture("supply"));
					dtpReceivedDate.Value = currentTime;
					return;
				}
				this._currentSupply.ReceiptDate = this.dtpReceivedDate.Value;
				//Since we're accepting the date, set the ExpirationDate's MinValue to trash my broken rules work
				//I'm not going to start auto-setting fields, unless they ask me to, so only check > 
				if (this.dtpExpirationDate.Value > this.dtpReceivedDate.Value)
				{
					this.dtpExpirationDate.MinDate = this.dtpReceivedDate.Value;
				}
				
			}
		}

		private void cmbManufacturer_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading && this.cmbManufacturer.Text.Length > 0 )
			{
				this._currentSupply.ManufacturerName = this.cmbManufacturer.Text;
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cmbComment.SelectedIndex != -1)
				{
					//this.txtDetails.Enabled = (this.cmbComment.Text == "Other");
					string comment = this.cmbComment.Text + " " + this.txtDetails.Text;
					this._currentSupply.Comments = comment.Trim();
					//
					//Details required if Comment = Other
					if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
					{
						this.lblDetails.Text = "Details*";
						this._detailsRequired = true;
					}
					else
					{
						this.lblDetails.Text = "Details";
						this._detailsRequired = false;
					}
					this.ObjectValidityChange(this, System.EventArgs.Empty);
				}
				else
				{
					this._currentSupply.Comments = "";
					this.lblDetails.Text = "Details";
					this._detailsRequired = false;
					this.ObjectValidityChange(this, System.EventArgs.Empty);
				}
			}
		}

		private void txtDetails_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				string comment = this.cmbComment.Text + " " + this.txtDetails.Text;
				this._currentSupply.Comments = comment.Trim();
				this.ObjectValidityChange(this, System.EventArgs.Empty);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("supply")) == DialogResult.Yes)
			{
				//Build the arraylist of supplies to add
				System.Collections.ArrayList newSupplies = new System.Collections.ArrayList();
				for (int ndx=0; ndx < this.lvInventory.CheckedItems.Count; ndx++)
				{
					newSupplies.Add((BOL.Supply)this.lvInventory.CheckedItems[ndx].Tag);
				}
				
				if(BOL.Supply.InsertSupplies(newSupplies, Common.UpdateFunction.UC081_FrmLogInSupplies))
				{
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.LoginSupply);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					this.Close();
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("supply"));
				}
			}		
		}

		private void updQuantity_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				try
				{
					//For a newly entered supply, the lot and available quantities should be the same
					this._currentSupply.LotQuantity = System.Convert.ToInt32(this.updQuantity.Value);
					this._currentSupply.AvailableQuantity = this._currentSupply.LotQuantity;	
					this.errError.SetVbecsError(updQuantity, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException)
				{
					this._currentSupply.LotQuantity = int.MinValue;
					this._currentSupply.AvailableQuantity = int.MinValue;
				}
			}
		}

		private void updQuantity_Leave(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				try
				{
					//For a newly entered supply, the lot and available quantities should be the same
					this._currentSupply.LotQuantity = System.Convert.ToInt32(this.updQuantity.Value);
					this._currentSupply.AvailableQuantity = this._currentSupply.LotQuantity;
					this.errError.SetVbecsError(updQuantity, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					this._currentSupply.LotQuantity = int.MinValue;
					this._currentSupply.AvailableQuantity = int.MinValue;
					this.errError.SetVbecsError(updQuantity, err.Message); // **** 508 Compliance ***
				}
			}
		}


		private void lvInventory_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if ((this.lvInventory.CheckedItems.Count == 1 && e.NewValue == CheckState.Unchecked) ||
				(this.lvInventory.CheckedItems.Count == 0 && e.NewValue != CheckState.Checked))
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
			else
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}

			//Save off whether the supply was selected or not for when RefreshInventory is called
			System.Guid supplyGuid = ((BOL.Supply)this.lvInventory.Items[e.Index].Tag).SupplyGuid;
			this._lvSuppliesChecked[supplyGuid] = (e.NewValue == CheckState.Checked);
		}


		private void cmbManufacturer_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.ManufacturerName = this.cmbManufacturer.Text;
				this.cmbManufacturer.SelectionLength = 0;
				//
				this.PopulateSupplyNameComboBox();
			}
		}

		private void dtpExpirationDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.LotExpirationDate = this.dtpExpirationDate.Value;
			}
		}

		private void cmbManufacturer_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.ManufacturerName = this.cmbManufacturer.Text;
			}
		}


		#endregion


		#region Events

		private void SatisfactoryIndicatorChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				bool isSatisfactory = (this.rdoSatisfactory.Checked);

				this._currentSupply.SatisfactoryIndicator = isSatisfactory;

				//If they're setting it to satisfactory, clean out the comments
				if (isSatisfactory)
				{
					this.cmbComment.SelectedIndex = -1;
					this.txtDetails.Text = string.Empty;
				}

				//Set the "required" indicator based on what they've selected
				if (isSatisfactory)
					this.lblComment.Text = "Comment";
				else
					this.lblComment.Text = "Comment*";

				this.cmbComment.Enabled = (!isSatisfactory);
				this.txtDetails.Enabled = (!isSatisfactory);		// && (this.cmbComment.Text == "Other"));
			}
		}


		/// <summary>
		/// Attached to the Supply object's OnValid/Invalid events
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ObjectValidityChange(object sender, System.EventArgs e)
		{
			string detailsRule = string.Empty;

			bool enableSupply = (!this._currentSupply.IsRuleBroken(Common.VbecsBrokenRules.FrmLogInSupplies.InvoiceNumber) &&
				!this._currentSupply.IsRuleBroken(Common.VbecsBrokenRules.FrmLogInSupplies.ReceiptDate) &&
				!this._currentSupply.IsRuleBroken(Common.VbecsBrokenRules.FrmLogInSupplies.ManufacturerName)
				);

			if (enableSupply)
			{
				if (!this.grpSupply.Enabled)
				{
					this.grpSupply.Enabled = true;
				}
				this.EnableSupplyFields(this._isNameSet);
			}
			else
				this.grpSupply.Enabled = false;


			if (this._detailsRequired && this.txtDetails.Text.Length == 0)
			{
				detailsRule = Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString;
			}

			string brokenRules = Common.Utility.SumBrokenRulesMessages(this._currentSupply.GetBrokenRulesMessage(this.Name), detailsRule);

			if (brokenRules == string.Empty)
			{
				this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC081.AddSupplyToList().ResString);
				this.btnAdd.EnabledButton = true;
			}
			else
			{
				this.btnAdd.SetToolTip(brokenRules);
				this.btnAdd.EnabledButton = false;
			}

		}

		#endregion

		private void ManufacturerSupplyNameEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.SupplyName = this.cmbManufacturerSupplyName.Text;
				this._isNameSet = (this.cmbManufacturerSupplyName.Text.Length > 0);
				this.UpdateAddButtonCaption();
			}
		}

		private void LotNumberEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._currentSupply.LotNumber = this.txtLotNumber.Text;
				this.UpdateAddButtonCaption();
			}
		}

		private void SupplyTypeEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cmbSupplyType.SelectedIndex > -1)
				{
					this._currentSupply.SupplyTypeId = (int)this._supplyTypeIds[this.cmbSupplyType.SelectedIndex];
					this._currentSupply.SupplyTypeText = this.cmbSupplyType.Text;
				}
				else
				{
					this._currentSupply.SupplyTypeId = 0;
					this._currentSupply.SupplyTypeText = "";
				}
				this.UpdateAddButtonCaption();
			}
		}

		private void lvInventory_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				this._isEdit = true;
				
				//Event fires twice per index change
				if (this.lvInventory.SelectedItems.Count != 0)
				{
					this.GetNewSupply();
				
					this._isLoading = true;

					this.cmbManufacturerSupplyName.Text = this._currentSupply.SupplyName;
					this._isNameSet = true;		//Fire manually because _isLoading = true
					this.cmbSupplyType.Text = this._currentSupply.SupplyTypeText;
					this.txtLotNumber.Text = this._currentSupply.LotNumber;
					this.dtpExpirationDate.Value = this._currentSupply.LotExpirationDate;
					try
					{
						this.updQuantity.Value = (decimal)this._currentSupply.LotQuantity;
						this.errError.SetVbecsError(this.updQuantity, string.Empty); // **** 508 Compliance ***
					}
					catch(FormatException)
					{
						this.updQuantity.Value = this.updQuantity.Minimum;
					}
					this.rdoSatisfactory.Checked = (this._currentSupply.SatisfactoryIndicator);
					this.rdoUnsatisfactory.Checked = (!this._currentSupply.SatisfactoryIndicator);

					this.btnAdd.Text = "&Update";

					//Fire the event to set the broken rules
					this.ObjectValidityChange(this, System.EventArgs.Empty);

					this._isLoading = false;
				}
				this.SpeakListViewWithCheckBox(lvInventory);
			}
		}

		private void txtDetails_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (!this._isLoading)
			{
				string comment = this.cmbComment.Text + " " + this.txtDetails.Text;
				this._currentSupply.Comments = comment.Trim();
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmLogInSupplies_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnAdd.EnabledButton )
			{
				textToSpeak = this.btnAdd.GetToolTip();
			}
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = string.Concat(textToSpeak, this.btnOK.GetToolTip());
			}
			//
			if ( textToSpeak.Length > 0 )
			{
				this.SpeakMessage( textToSpeak );
			}
		}
	}
}

